/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Material *brick,
         *glass;
Mesh      mbox ,
          mball;
Vec       pos[32];

Window   window;
CheckBox dof_hi;
ComboBox dof_blurs;
Slider   dof_power,
         dof_range;
Text    tdof_hi,
        tdof_blurs,
        tdof_power,
        tdof_range;
/******************************************************************************/
void InitPre()
{
   App.name="Depth of Field";
   App.flag=APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.full(true).dof(DOF_HIGH,1, 1,0,5); // set initial depth of field parameters

   // hide mouse
   Ms.hide();
}
/******************************************************************************/
Bool Init()
{
   brick=Materials("../data/mtrl/brick/0.mtrl");
   glass=Materials("../data/mtrl/glass/0.mtrl");

   mbox .create(1).B(0).create( Box(  4),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create mesh box, reverse it because it's meant to be viewed from inside
   mball.create(1).B(0).create(Ball(0.5),VTX_TX0|VTX_NRM|VTX_TNG)          ; // create mesh ball

   // set mesh materials, rendering versions and bounding boxes
   mbox .setMaterial(brick).setRender().setBox();
   mball.setMaterial(glass).setRender().setBox();

   // set random positions inside box
   REPA(pos)pos[i]=Rnd(mbox.box);

   // set camera
   Cam.at   = mbox.box.cornerLDF()/2;
   Cam.dist = 10;
   Cam.pitch=-PI_4;
   Cam.yaw  = PI_4;

   // add gui Dof controls
   static Char *blurs[]=
   {
      "1",
      "2",
      "3",
   };
   Gui   +=window    .create(Rect_C(0,-0.7,0.9,0.50),"Depth of Field Parameters").hide();
   window+=tdof_hi   .create(Vec2(0.2,-0.08),"High Quality"); window+=dof_hi   .create(Rect_C(0.2+window.crect.w()/2,-0.08,0.05,0.05),D.dofMode ()==DOF_HIGH).setDesc("Prevents foreground objects leaking into background");
   window+=tdof_blurs.create(Vec2(0.2,-0.16),"Blurs"       ); window+=dof_blurs.create(Rect_C(0.2+window.crect.w()/2,-0.16,0.25,0.05),blurs,ELMS(blurs)).set(D.dofBlurs()-1);
   window+=tdof_power.create(Vec2(0.2,-0.24),"Power"       ); window+=dof_power.create(Rect_C(0.2+window.crect.w()/2,-0.24,0.25,0.05),D.dofPower());
   window+=tdof_range.create(Vec2(0.2,-0.32),"Range"       ); window+=dof_range.create(Rect_C(0.2+window.crect.w()/2,-0.32,0.25,0.05),D.dofRange()/10);

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   CamHandle(0.01,100,Ms.hidden ? CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT) : 0); // when mouse hidden operate the camera

   if(Kb.bp(KB_TAB))
   {
      Ms    .toggle               (); // toggle mouse  visibility when tab pressed
      window.visibleToggleActivate(); // toggle window visibility when tab pressed
   }

   // set depth of field parameters
   D.dof(dof_hi () ? DOF_HIGH : DOF_ON, dof_blurs()+1, dof_power(), Cam.dist, dof_range()*10);

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox.draw(MatrixIdentity);
         REPA(pos)
         {
            glass->color.v3=ColorVec(ColorHue(Flt(i)/ELMS(pos)));
            mball.draw(Matrix(pos[i]));
         }
      break;

      case RM_LIGHT:
         LightPoint(25,Vec(0,3,0)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   Gui.draw();
   if(Ms.hidden)D.text(0,0.9,S+"Press Tab to toggle parameters");
   else         D.text(0,0.9,S+"Fps "+Tm.fps);
}
/******************************************************************************/
